<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Authentication\Models\User;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class AddReservationWebNotificationType extends Migration
{
    public function up(): void
    {
        /** @var NotificationType $notificationType */
        $notificationType = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => null,
                'model'     => null,
                'action'    => 'reservation',
                'condition' => null,
                'multiple'  => true,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.reservation.web.<notification_name>.title',
                    'description' => 'notifications.reservation.web.<notification_name>.description',
                    'icon'        => 'reservation',
                    'text'        => 'notifications.reservation.web.<notification_name>.text',
                    'fields'      => ['title'],
                ],
            ]
        );
        User::each(
            function ($user) use ($notificationType) {
                NotificationSubscriber::firstOrCreate(
                    [
                        'user_uuid'            => $user->uuid,
                        'notification_type_id' => $notificationType->id,
                    ]
                );
            }
        );
    }
}
