<?php

namespace Inside\Reservation\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Log;
use Recurr\Exception\InvalidRRule;

class Rrule implements Rule
{
    protected ?string $error = null;

    protected ?string $value = null;

    public function passes($attribute, $value): bool
    {
        if ($value == null) {
            return true;
        }
        try {
            $rule = new \Recurr\Rule($value);
        } catch (InvalidRRule $e) {
            Log::error("[rrule validation] failed on [{$value}] => " . $e->getMessage());
            $this->error = $e->getMessage();
            $this->value = $value;

            return false;
        }

        return true;
    }

    public function message(): string
    {
        return Lang::get(
            'validation.rrule',
            ['value' => $this->value, 'message' => $this->error]
        );
    }
}
