<?php

namespace Inside\Reservation\Providers;

use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Events\ContentSynchedEvent;
use Inside\Content\Events\ContentUpdatingEvent;
use Inside\Content\Transformers\ContentTransformer;
use Inside\Reservation\Console\CreateContentTypes;
use Inside\Reservation\Contracts\Reservation as ReservationContract;
use Inside\Reservation\Http\Middleware\ReservationValidation;
use Inside\Reservation\Http\Middleware\SetDefaultCooldownOnReservationForm;
use Inside\Reservation\Listeners\FixIcsAttachment;
use Inside\Reservation\Listeners\WarnParticipantOnBookingCreated;
use Inside\Reservation\Listeners\UpdateReservationsOnRoomUpdating;
use Inside\Reservation\Listeners\WarnParticipantOnBookingRelationChanges;
use Inside\Reservation\Listeners\WarnParticipantOnBookingUpdating;
use Inside\Reservation\Repositories\ReservationRepository;
use Inside\Reservation\Services\ReservationService;
use Inside\Support\EventServiceProvider;

class ReservationServiceProvider extends EventServiceProvider
{
    protected array $listen = [
        ContentCreatedEvent::class  => [
            WarnParticipantOnBookingCreated::class,
        ],
        ContentUpdatingEvent::class => [
            WarnParticipantOnBookingUpdating::class,
            UpdateReservationsOnRoomUpdating::class
        ],
        ContentSynchedEvent::class  => [
            WarnParticipantOnBookingRelationChanges::class,
        ],
    ];

    protected array $commands = [
        CreateContentTypes::class,
    ];

    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__.'/../../config/reservation.php', 'reservation');
        $this->app->middleware([
            ReservationValidation::class,
            SetDefaultCooldownOnReservationForm::class,
        ]);
        $this->app->singleton(
            ReservationContract::class,
            function () {
                return new ReservationService(new ContentTransformer(), new ReservationRepository());
            }
        );
    }
}
