<?php

namespace Inside\Reservation\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Content\Transformers\ContentTransformer;
use Inside\Reservation\Facades\Reservation;
use InvalidArgumentException;

class ReservationController
{
    /**
     * @var ContentTransformer
     */
    protected $transformer;

    /**
     * @param ContentTransformer $transformer
     */
    public function __construct(ContentTransformer $transformer)
    {
        $this->transformer = $transformer;
    }

    /**
     * @param Request $request
     * @param string $types
     * @return JsonResponse
     */
    public function index(Request $request, string $types): JsonResponse
    {
        $types = explode(',', $types);
        $startDate = $request->get('start_date');
        $endDate = $request->get('end_date');
        if (null === $startDate || null === $endDate) {
            throw new InvalidArgumentException('You must set start & end date');
        }

        return response()->json(
            Reservation::getReservationList(
                $types,
                $startDate,
                $endDate,
                ContentHelper::extractFiltersInputFromRequest($request),
                ContentHelper::extractFieldsInputFromRequest($request)
            )
        );
    }
}
