<?php

use Illuminate\Support\Facades\Route;
use Inside\Quiz\Http\Controllers\Answer;
use Inside\Quiz\Http\Controllers\Export;
use Inside\Quiz\Http\Controllers\Get;

Route::group(
    [
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('quiz/{uuid}', Get::class);
        $router->post('quiz/export/{uuid}', Export::class);
        $router->post('quiz/answer', Answer::class);
    }
);
