<?php

namespace Inside\Quiz\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;
use Inside\Quiz\Events\QuizCSVGeneratedEvent;

class QuizCSVGeneratedListener extends BaseNotificationListener implements ShouldQueue
{
    /**
     * @param QuizCSVGeneratedEvent $event
     * @return void
     */
    public function handle(QuizCSVGeneratedEvent $event): void
    {
        /** @var Collection<NotificationType> $types */
        $types = NotificationType::where('action', 'quiz-export')->get();

        foreach ($types as $type) {
            /** @var User $user */
            $user = User::find($event->uuid); // @phpstan-ignore-line

            $this->when = $this->getInterval($type);
            $this->route = $user;
            $this->notify(
                $type,
                $user,
                null,
                [
                    'extra' => [
                        'link' => Storage::disk('protected')->url($event->filePath),
                    ],
                ]
            );
        }
    }
}
