<?php

namespace Inside\Quiz\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Quiz;
use Inside\Content\Models\Sections\Question;
use Inside\Quiz\Facades\Quiz as QuizService;
use Inside\Quiz\Http\Requests\QuizAnswerStoreRequest;

class Answer extends Controller
{
    public function __invoke(QuizAnswerStoreRequest $request): JsonResponse
    {
        /** @var ?User $user */
        $user = Auth::user();

        $quizUuid = $request->get('quiz');
        $quiz = Quiz::query()->findOrFail($quizUuid);
        $questionUuid = $request->get('question');
        $question = Question::query()->findOrFail($questionUuid);

        if ($question->sectionable->uuid !== $quiz->uuid) {
            return response()->json([
                'success' => false,
                'error' => Lang::get('quiz.validation.question_quiz.nomatch'),
            ], 406);
        }

        $submission = QuizService::userLastSubmission($user, $quiz);

        if (QuizService::userAnswerExists($user, $submission, $quiz, $question)) {
            return response()->json([
                'success' => false,
                'error' => Lang::get('quiz.validation.already_answered'),
            ], 409);
        }

        $answerUuids = $request->get('answer');

        foreach ($answerUuids as $answerUuid) {
            $answer = \Inside\Content\Models\Sections\Answer::query()->findOrFail($answerUuid);

            if ($answer->sectionable->uuid !== $question->uuid) {
                return response()->json([
                    'success' => false,
                    'error' => Lang::get('quiz.validation.answer_question.nomatch'),
                ], 406);
            }
        }

        $answers = $question->sectionContent;
        $correctAnswersNumber = 0;
        $correctAnswersNumberUser = 0;

        foreach ($answers as $answer) {
            if ($answer->answer_correct) {
                $correctAnswersNumber++;

                if (in_array($answer->uuid, $answerUuids)) {
                    $correctAnswersNumberUser++;
                }
            }
        }

        $correct = $correctAnswersNumberUser === $correctAnswersNumber;

        QuizService::storeAnswer($user, $submission, $quiz, $question, $answerUuids, $correct);

        $data = [
            'correct' => $correct,
            'details' => $correct ? $question->question_correct_answer : $question->question_wrong_answer,
            'completed' => QuizService::userAnswersCompleted($user, $submission, $quiz),
        ];

        if ($data['completed']) {
            $score = QuizService::getUserScore($user, $submission, $quiz);

            if ($quiz->quiz_show_final_score) {
                $data['score'] = $score;
            }

            QuizService::storeScore($user, $submission, $quiz, $score);

            if ($quiz->quiz_show_average) {
                $data['average'] = QuizService::getAverage($quiz);
            }
        }

        return response()->json([
            'success' => true,
            'data' => $data
        ]);
    }
}
