<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ChangeBgColorFieldWidget extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'quiz',
            'quiz_background_color',
            [
                'name' => 'quiz_background_color',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Bandeau de fond',
                    'en' => 'Banner background'
                ],
                'description' => [
                    'fr' => 'Renseignez la valeur hexadécimale de la couleur que vous voulez voir affichée dans le bandeau du quiz',
                    'en' => 'Set the hexadecimal value of the color you want to display in the quiz background'
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                    'settings' => [],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
