<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class CreateQuizAnswersTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('inside_quiz_answers')) {
            Schema::create('inside_quiz_answers', function (Blueprint $table) {
                $table->tinyInteger('submission');
                $table->uuid('user_uuid');
                $table->uuid('quiz_uuid');
                $table->uuid('question_uuid');
                $table->string('answer');
                $table->boolean('correct');
                $table->timestamp('answered_at');
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
                $table->foreign('quiz_uuid')->references('uuid')->on('inside_content_quiz')->onDelete('cascade');
                $table->foreign('question_uuid')->references('uuid')->on('inside_section_question')->onDelete('cascade');
            });

            Schema::table(
                'inside_quiz_answers',
                function (Blueprint $table) {
                    $table->primary(['submission', 'user_uuid', 'quiz_uuid', 'question_uuid'], 'inside_quiz_answers_primary');
                }
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_quiz_answers');
    }
}
