<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Facades\DynamicClass;

class AddQuizContentType extends Migration
{
    use CreateContentTypes;
    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();
        $this->bootUp(__FILE__, 'Adding quiz content type and sections');

        $this->getConsole()->writeln("<info>Adding the answer section type</info>");
        $this->migrateContent('answer', false, 'sections');
        $this->getConsole()->writeln("<info>Adding the question section type</info>");
        $this->migrateContent('question', false, 'sections');
        $this->getConsole()->writeln("<info>Adding the quiz content type</info>");
        $this->migrateContent('quiz');

        $this->finishUp();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }

    public function down(): void
    {
        $this->bootDown(__FILE__);
        $this->finishDown();
    }
}
