<?php

namespace Inside\Quiz\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Quiz;
use Inside\Quiz\Facades\Quiz as QuizService;
use Inside\Content\Contracts\Transformer as TransformerContract;

class Get extends Controller
{
    public function __invoke(TransformerContract $transformer, string $uuid): JsonResponse
    {
        /** @var Quiz $quiz */
        $quiz = Quiz::findOrFail($uuid); // @phpstan-ignore-line

        $data = $transformer->transform($quiz); // @phpstan-ignore-line
        unset($data['content']);

        /** @var ?User $user */
        $user = Auth::user();

        $data['questions'] = QuizService::extractQuestions($quiz, $user);
        $submission = QuizService::userLastSubmission($user, $quiz);
        $data['completed'] = QuizService::userAnswersCompleted($user, $submission, $quiz);

        if ($data['completed']) {
            if ($quiz->quiz_show_final_score) {
                $data['score'] = QuizService::getUserScore($user, $submission, $quiz);
            }

            if ($quiz->quiz_show_average) {
                $data['average'] = QuizService::getAverage($quiz);
            }
        }

        $data['number_of_participants'] = QuizService::getNumberOfParticipants($quiz);

        return response()->json([
            'success' => true,
            'data' => $data
        ]);
    }
}
