<?php

namespace Inside\Quiz\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Quiz;
use Inside\Permission\Facades\Permission;
use Inside\Quiz\Jobs\GenerateQuizCSV;

class Export extends Controller
{
    public function __invoke(string $uuid): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();
        $quiz = Quiz::findOrFail($uuid);
        if (!Permission::can('update', $quiz)) {
            return response()->json(['error' => 'Unauthenticated.'], 403);
        }

        GenerateQuizCsv::dispatch($user->uuid, $quiz);

        return response()->json([
            'success' => true,
        ]);
    }
}
