<?php

namespace Inside\Quiz\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Events\Dispatchable;

class QuizCSVGeneratedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    public function __construct(
        public string $uuid,
        public string $filePath
    ) {
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside_quiz');
    }
}
