<?php

namespace Inside\Quiz\Contracts;

use Inside\Authentication\Models\User;
use Inside\Content\Models\Sections\Question;

interface Quiz
{
    public function userLastSubmission(User $user, \Inside\Content\Models\Contents\Quiz $quiz): int;

    public function userAnswersCompleted(User $user, int $submission, \Inside\Content\Models\Contents\Quiz $quiz): bool;

    public function userAnswerExists(User $user, int $submission, \Inside\Content\Models\Contents\Quiz $quiz, Question $question): bool;

    public function getUserScore(User $user, int $submission, \Inside\Content\Models\Contents\Quiz $quiz): int;

    public function getAverage(\Inside\Content\Models\Contents\Quiz $quiz): float;

    public function storeAnswer(User $user, int $submission, \Inside\Content\Models\Contents\Quiz $quiz, Question $question, array $answers, bool $correct): void;

    public function storeScore(User $user, int $submission, \Inside\Content\Models\Contents\Quiz $quiz, int $score): void;

    public function extractQuestions(\Inside\Content\Models\Contents\Quiz $quiz, User $user = null): array;

    public function getNumberOfParticipants(\Inside\Content\Models\Contents\Quiz $quiz): int;

    public function getResults(\Inside\Content\Models\Contents\Quiz $quiz): array;
}
