<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'question',
        'title' => [
            'fr' => 'Question',
            'en' => 'Question',
        ],
    ],
    'fields' => [
        [
            'name' => 'question_title',
            'translatable' => (count(list_languages()) > 1),
            'default' => '',
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Titre de votre question',
                'en' => 'Title of your question'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::TEXT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'question_details',
            'required' => false,
            'translatable' => (count(list_languages()) > 1),
            'weight' => 1,
            'default' => '',
            'title' => [
                'fr' => 'Complément d\'information sur votre question',
                'en' => 'Details about your question'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [],
        ],
        [
            'name' => 'question_image',
            'required' => false,
            'translatable' => (count(list_languages()) > 1),
            'weight' => 2,
            'title' => [
                'fr' => 'Image d\'illustration de votre question',
                'en' => 'Image of your question'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'mimetypes' => 'image/png,image/gif,image/jpeg',
                    'file_extensions' => 'png,gif,jpg,jpeg',
                ],
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
        ],
        [
            'name' => 'content',
            'translatable' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Réponses',
                'en' => 'Answers',
            ],
            'settings' => [
                'target_type' => [
                    'answer',
                ],
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::SECTION_FIELD,
        ],
        [
            'name' => 'question_correct_answer',
            'required' => false,
            'translatable' => (count(list_languages()) > 1),
            'weight' => 4,
            'default' => '',
            'title' => [
                'fr' => 'Donnez des précisions en cas de bonne réponse',
                'en' => 'Details in case of a correct answer'
            ],
            'description' => [
                'fr' => 'Ces informations seront affichées uniquement si la question a plusieurs bonnes réponses',
                'en' => 'These details will only be displayed if the question has multiple correct answers'
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [],
        ],
        [
            'name' => 'question_wrong_answer',
            'required' => false,
            'translatable' => (count(list_languages()) > 1),
            'weight' => 5,
            'default' => '',
            'title' => [
                'fr' => 'Donnez des précisions en cas de mauvaise réponse',
                'en' => 'Details in case of a wrong answer'
            ],
            'description' => [
                'fr' => 'Ces informations seront affichées uniquement si la question a plusieurs bonnes réponses',
                'en' => 'These details will only be displayed if the question has multiple correct answers'
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [],
        ],
    ],
];
