<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'answer',
        'title' => [
            'fr' => 'Réponse',
            'en' => 'Answer',
        ],
    ],
    'fields' => [
        [
            'name' => 'answer_title',
            'default' => '',
            'translatable' => (count(list_languages()) > 1),
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Réponse',
                'en' => 'Answer'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::TEXT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'answer_correct',
            'required' => false,
            'weight' => 1,
            'default' => false,
            'title' => [
                'fr' => 'Réponse correcte',
                'en' => 'Correct answer',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [],
        ],
    ],
];
