<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddExportNotificationType extends Migration
{
    public function up(): void
    {
        $notificationTypes = [];

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Quiz\Events\QuizCSVGeneratedEvent',
                'model' => null,
                'type' => 'system',
                'action' => 'quiz-export',
                'condition' => null,
                'multiple' => false,
                'language' => true,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.quiz.export.title',
                    'description' => 'notifications.quiz.export.description',
                    'icon' => 'quiz',
                    'text' => 'notifications.quiz.export.text',
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
