<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateQuizScoresTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('inside_quiz_scores')) {
            Schema::create('inside_quiz_scores', function (Blueprint $table) {
                $table->tinyInteger('submission');
                $table->uuid('user_uuid');
                $table->uuid('quiz_uuid');
                $table->tinyInteger('score');
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
                $table->foreign('quiz_uuid')->references('uuid')->on('inside_content_quiz')->onDelete('cascade');
            });

            Schema::table(
                'inside_quiz_scores',
                function (Blueprint $table) {
                    $table->primary(['submission', 'user_uuid', 'quiz_uuid'], 'inside_quiz_scores_primary');
                }
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_quiz_scores');
    }
}
