<?php
use Inside\Host\Bridge\BridgeContentType;
return [
    'options' => [
        'name' => 'quiz',
        'translatable' => (count(list_languages()) > 1),
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Quiz',
            'en' => 'Quiz',
        ],
    ],
    'fields' => [
        [
            'name' => 'quiz_description',
            'searchable' => false,
            'translatable' => (count(list_languages()) > 1),
            'default' => 'Entrez ici la description du quiz',
            'search_result_field' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Description',
                'en' => 'Description'
            ],
            'description' => [
                'fr' => 'La description du quiz s\'affiche sous le titre sur la page d\'introduction',
                'en' => 'The quiz description is displayed below the title on the introduction page',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'quiz_image',
            'searchable' => false,
            'translatable' => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image'
            ],
            'description' => [
                'fr' => 'Cette image sera affichée dans le listing des quiz',
                'en' => 'This image will be displayed in the quizzes listing'
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'quiz_background_color',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Bandeau de fond',
                'en' => 'Banner background'
            ],
            'description' => [
                'fr' => 'Renseignez la valeur hexadécimale de la couleur que vous voulez voir affichée dans le bandeau du quiz',
                'en' => 'Set the hexadecimal value of the color you want to display in the quiz background'
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'quiz_end_date',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Date et heure de fin du quiz',
                'en' => 'End date and hour of the quiz'
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'quiz_end_title',
            'searchable' => false,
            'translatable' => (count(list_languages()) > 1),
            'default' => "Merci pour votre participation,",
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Titre si quiz terminé',
                'en' => 'Title if quiz ended'
            ],
            'description' => [
                'fr' => 'Remplissez ce champ si vous souhaitez un titre personnalisé lorsque le quiz n\'est plus disponible',
                'en' => 'Fill this field if you want to display a custom title when the quiz is no longer available'
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'quiz_end_description',
            'searchable' => false,
            'translatable' => (count(list_languages()) > 1),
            'default' => 'Le quiz est désormais terminé, rendez-vous très prochainement pour un prochain quiz ;)',
            'search_result_field' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Description si quiz terminé',
                'en' => 'Description if quiz ended'
            ],
            'description' => [
                'fr' => 'Remplissez ce champ si vous voulez une description personnalisée lorsque le quiz n\'est plus disponible',
                'en' => 'Fill this field if you want to display a custom description when the quiz is no longer available'
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'quiz_show_final_score',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 6,
            'default' => true,
            'title' => [
                'fr' => 'Afficher le score final',
                'en' => 'Display the final score'
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 6,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'quiz_unique_submission',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 7,
            'default' => true,
            'title' => [
                'fr' => 'Limiter à une seule soumission',
                'en' => 'Allow only one submission',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 7,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'quiz_show_average',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 8,
            'default' => true,
            'title' => [
                'fr' => 'Afficher la moyenne des répondants',
                'en' => 'Display the average of respondents'
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 8,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 9,
            'title' => [
                'fr' => 'Questions',
                'en' => 'Questions',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 9,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'question',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
