<?php
use Inside\Host\Bridge\BridgeContentType;
return [
    'options' => [
        'name' => 'organization_items',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Utilisateur organigramme',
            'en' => 'Organizational chart user',
            'de' => 'Benutzer Organigramm',
            'es' => 'Organigrama de usuario',
            'nl' => 'Gebruikersorganogram',
            'pt' => 'Organograma de Usuário',
        ],
    ],
    'fields' => [
        [
            'name' => 'organizations',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Organigramme',
                'en' => 'Organizational chart',
                'de' => 'Organigramm',
                'es' => 'Organigrama',
                'nl' => 'Organogram',
                'pt' => 'Organograma',
            ],
            'description' => [
                'fr' => 'Choix de l\'organigramme dans lequel l\'utilisateur doit remonter',
                'en' => 'Choose the org chart to which the user should be associated',
                'de' => 'Wählen Sie das Organigramm, dem der Benutzer zugeordnet werden soll',
                'es' => 'Elija el organigrama al que se debe asociar al usuario',
                'nl' => 'Kies het organogram waaraan de gebruiker moet worden gekoppeld',
                'pt' => 'Escolha o organograma ao qual o usuário deve ser associado',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['organizations'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'organization_items',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Manager',
                'en' => 'Manager',
                'de' => 'Manager',
                'es' => 'Gerente',
                'nl' => 'Manager',
                'pt' => 'Gerente',
            ],
            'description' => [
                'fr' => 'Choix du manager de l\'utilisateur. Si non coché alors l\'utilisateur se place en haut de l\'organigramme',
                'en' => 'Select the user\'s manager. If not checked, the user will be placed at the top of the org chart',
                'de' => 'Wählen Sie den Manager des Benutzers aus. Wenn nicht ausgewählt, wird der Benutzer oben im Organigramm platziert',
                'es' => 'Seleccione el gerente del usuario. Si no está marcado, el usuario se ubicará en la parte superior del organigrama',
                'nl' => 'Selecteer de manager van de gebruiker. Als niet aangevinkt, wordt de gebruiker bovenaan het organogram geplaatst',
                'pt' => 'Selecione o gerente do usuário. Se não estiver marcado, o usuário será colocado no topo do organograma',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['organization_items'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'users',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Utilisateur',
                'en' => 'User',
                'de' => 'Benutzer',
                'es' => 'Usuario',
                'nl' => 'Gebruiker',
                'pt' => 'Usuário',
            ],
            'description' => [
                'fr' => 'Choix de l\'utilisateur de l\'intranet. Si ce champ est complété il prend la main sur les champs suivants',
                'en' => 'Choose the intranet user. If this field is filled, it takes precedence over the following fields',
                'de' => 'Wählen Sie den Intranet-Benutzer. Wenn dieses Feld ausgefüllt ist, hat es Vorrang vor den folgenden Feldern',
                'es' => 'Elija al usuario de la intranet. Si este campo está completado, tiene prioridad sobre los siguientes campos',
                'nl' => 'Kies de intranetgebruiker. Als dit veld is ingevuld, heeft het voorrang op de volgende velden',
                'pt' => 'Escolha o usuário da intranet. Se este campo estiver preenchido, ele tem prioridade sobre os campos seguintes',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Photo utilisateur',
                'en' => 'User Photo',
                'de' => 'Benutzerfoto',
                'es' => 'Foto de usuario',
                'nl' => 'Gebruikersfoto',
                'pt' => 'Foto do Usuário',
            ],
            'description' => [
                'fr' => 'Si l\'utilisateur n\'est pas un utilisateur de l\'intranet',
                'en' => 'If the user is not an intranet user',
                'de' => 'Wenn der Benutzer kein Intranet-Benutzer ist',
                'es' => 'Si el usuario no es un usuario de la intranet',
                'nl' => 'Als de gebruiker geen intranetgebruiker is',
                'pt' => 'Se o usuário não for um usuário da intranet',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'function',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Fonction utilisateur',
                'en' => 'User Function',
                'de' => 'Benutzerfunktion',
                'es' => 'Función de usuario',
                'nl' => 'Gebruikersfunctie',
                'pt' => 'Função do Usuário',
            ],
            'description' => [
                'fr' => 'Si l\'utilisateur n\'est pas un utilisateur de l\'intranet',
                'en' => 'If the user is not an intranet user',
                'de' => 'Wenn der Benutzer kein Intranet-Benutzer ist',
                'es' => 'Si el usuario no es un usuario de la intranet',
                'nl' => 'Als de gebruiker geen intranetgebruiker is',
                'pt' => 'Se o usuário não for um usuário da intranet',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'assistants',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Assistants',
                'en' => 'Assistants',
                'de' => 'Assistenten',
                'es' => 'Asistentes',
                'nl' => 'Assistenten',
                'pt' => 'Assistentes',
            ],
            'description' => [
                'fr' => 'Définir les assistants de l\'utilisateur',
                'en' => 'Define user assistants',
                'de' => 'Benutzer-Assistenten definieren',
                'es' => 'Definir asistentes de usuario',
                'nl' => 'Definieer gebruikersassistenten',
                'pt' => 'Definir assistentes de usuário',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display Order',
                'de' => 'Anzeigereihenfolge',
                'es' => 'Orden de visualización',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de Exibição',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lower number rises first',
                'de' => 'Die niedrigere Zahl steigt zuerst',
                'es' => 'El número más bajo sube primero',
                'nl' => 'Het lagere nummer stijgt eerst',
                'pt' => 'O número mais baixo sobe primeiro',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
