<?php

namespace Inside\Organization\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Inside\Host\Bridge\BridgeContent;
use Inside\Permission\Exceptions\AuthorizationException;
use Inside\Permission\Facades\Permission;
use Laravel\Lumen\Routing\Controller;

/**
 * Organization controller.
 *
 * @category Class
 * @package  Inside\Organization\Http\Controllers\OrganizationController
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class OrganizationController extends Controller
{
    /**
     * @param string $uuid
     *
     * @return JsonResponse
     * @throws \Exception
     */
    public function deleteCard(string $uuid): JsonResponse
    {
        $bridge = new BridgeContent();
        $type = 'organization_items';

        if (!Permission::allowed('delete', $type, $uuid)) {
            throw AuthorizationException::create('delete', $type);
        }

        $content = call_user_func(type_to_class($type).'::findOrFail', $uuid);
        $manager = $content->organizationItems->first()->uuid;
        $usersBelow = $content->reverseOrganizationItemsOrganizationItems;

        foreach ($usersBelow as $userBelow) {
            $bridge->contentUpdate($type, [
                'uuid' => $userBelow->uuid,
                'organization_items' => $manager,
            ]);
        }

        return new JsonResponse(
            [
                'status'      => $bridge->contentDelete($type, $uuid),
                'uuid'        => $uuid,
            ]
        );
    }
}
