<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Custom;
use Inside\Database\Eloquent\Builder;
use Inside\Host\Bridge\BridgeContent;

class AddOrganizationCustomPage extends Migration
{
    private const CUSTOM_SLUG = 'organizational-charts';
    private const REDIRECTION_PAGE = 'OrganizationsListingPage';
    private const TITLES = [
        'en' => 'Organizational Charts',
        'es' => 'Organigramas',
        'de' => 'Organisationsdiagramme',
        'nl' => 'Organigrammen',
        'pt' => 'Organigramas',
    ];

    public function up(): void
    {
        $customPage = type_to_class('custom')::query()->where(['custom_slug' => 'organizational-charts'])->first();
        if ($customPage) {
            return;
        }

        $bridge = new BridgeContent();
        $uuid = $bridge->contentInsert('custom', [
            'type' => 'node',
            'bundle' => 'custom',
            'langcode' => 'fr',
            'title' => 'Organigrammes',
            'custom_slug' => self::CUSTOM_SLUG,
            'redirection_page' => self::REDIRECTION_PAGE,
        ]);

        $createdCustomPage = type_to_class('custom')::find($uuid);
        foreach (list_languages() as $langcode) {
            if ($langcode === 'fr') {
                continue;
            }
            $bridge->contentInsert('custom', [
                'type' => 'node',
                'bundle' => 'custom',
                'langcode' => $langcode,
                'title' => self::TITLES[$langcode] ?? self::TITLES['en'] ,
                'uuid_host' => $createdCustomPage->uuid_host,
                'custom_slug' => self::CUSTOM_SLUG,
                'redirection_page' => self::REDIRECTION_PAGE,
            ]);
        }
    }
}
