<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddMoreInfoOrganizationItems extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'organization_items',
            fieldName: 'additional_information',
            options: [
                'name' => 'additional_information',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'title' => [
                    'en' => 'Additional information',
                    'fr' => 'Complément d\'information',
                    'de' => 'Zusätzliche Informationen',
                    'es' => 'Información adicional',
                    'nl' => 'Aanvullende informatie',
                    'pt' => 'Informações adicionais',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 10,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );

        Artisan::call('models:rebuild');

        $this->finishUp();
    }
}
