<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateOrganizationItemsAssistants extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->getBridge()?->contentTypeCreateOrUpdateField('organization_items', 'assistants_title', [
            'name' => 'assistants_title',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => "Titre de l'adjoint / assistant",
                'en' => 'Assistant / Deputy Title',
                'de' => 'Titel des Assistenten / Stellvertreters',
                'es' => 'Título del asistente / subalterno',
                'nl' => 'Titel van de assistent / plaatsvervanger',
                'pt' => 'Título do assistente / suplente',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);

        $this->getBridge()?->contentTypeCreateOrUpdateField('organization_items', 'assistants', [
            'name' => 'assistants',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Assistant(e) ou adjoint(e)',
                'en' => 'Assistant or Deputy',
                'de' => 'Assistent oder Stellvertreter',
                'es' => 'Asistente o suplente',
                'nl' => 'Assistent of plaatsvervanger',
                'pt' => 'Assistente ou adjunto',
            ],
            'description' => [
                'fr' => "Définir l'adjoint(e) ou l'assistant(e) de l'utilisateur",
                'en' => 'Define the assistant or deputy for the user',
                'de' => 'Definieren Sie den Assistenten oder Stellvertreter für den Benutzer',
                'es' => 'Definir el asistente o suplente para el usuario',
                'nl' => 'Definieer de assistent of plaatsvervanger voor de gebruiker',
                'pt' => 'Defina o assistente ou adjunto para o usuário',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
        ]);

        Artisan::call('models:rebuild');

        if (! class_exists(OrganizationItems::class)) {
            return;
        }

        $bridgeContent = new BridgeContent();

        OrganizationItems::each(static function ($item) use ($bridgeContent) {
            if ($item->assistants->count() > 1) {
                $bridgeContent->contentUpdate($item->content_type, [
                    'uuid' => $item->uuid,
                    'assistants' => [$item->assistants->first()->uuid],
                ]);
            }
        });

        $this->finishUp();
    }
}
