<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddOrganizationItemsIsEmpty extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField('organization_items', 'is_empty', [
            'name' => 'is_empty',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Bloc invisible',
                'en' => 'Invisible Block',
                'de' => 'Unsichtbarer Block',
                'es' => 'Bloque invisible',
                'nl' => 'Onzichtbaar blok',
                'pt' => 'Bloco invisível',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ]);
        $this->finishUp();
    }
}
