<?php

namespace Inside\Onboardings\Providers;

use Illuminate\Support\Facades\Event;
use Inside\Events\PageVisited;
use Inside\Onboardings\Listeners\OnboardingGameListener;
use Inside\Onboardings\Services\GameService;
use Inside\Support\EventServiceProvider;

/**
 * Inside Onboarding service.
 *
 * @category Class
 * @package  Inside\Onboardings\Providers
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */

class OnboardingServiceProvider extends EventServiceProvider
{
    protected array $listen = [
        PageVisited::class => [
            OnboardingGameListener::class
        ]
    ];

    public array $bindings = [
        'game' => GameService::class,
    ];

    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__.'/../../config/game.php', 'game');
    }
}
