<?php

namespace Inside\Onboardings\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Inside\Database\Eloquent\WithEnhancedBuilder;

class OnboardingGames extends Model
{
    use WithEnhancedBuilder;
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_onboarding_games';

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title',
        'description',
        'end_description',
        'pieces_count',
        'piece_height',
        'piece_width',
        'columns',
        'rows',
        'image_dimensions',
        'image',
        'default_image',
        'status',
        'langcode'
    ];

    /*
    **
    * The pieces linked to the game
    */
    public function pieces(): HasMany
    {
        return $this->hasMany(OnboardingPieces::class, 'game_id', 'id');
    }

    public function turns(): HasMany
    {
        return $this->hasMany(OnboardingTurns::class, 'game_id', 'id');
    }
}
