<?php

namespace Inside\Onboardings\Listeners;

use Inside\Events\PageVisited;
use Inside\Onboardings\Models\OnboardingPieces;
use Inside\Onboardings\Models\OnboardingTurns;

class OnboardingGameListener
{
    public function handle(PageVisited $event): void
    {
        $path = $event->path;
        $user = $event->user;
        $encodedPath = json_encode($path);

        if ($encodedPath === false) {
            return;
        }

        $pieces = OnboardingPieces::where(
            'urls',
            'like',
            '%'.addcslashes($encodedPath, '\_').'%'
        )->get();
        foreach ($pieces as $piece) {
            // get only activated game
            if (!$piece->game->status) {
                continue;
            }
            $player = OnboardingTurns::query()
                ->where('game_id', $piece->game->id)
                ->where('uuid', $user->uuid)
                ->where('piece_position', $piece->position)
                ->first();
            if ($player) {
                continue;
            }
            OnboardingTurns::create([
                'game_id' => $piece->game->id,
                'piece_position' => $piece->position,
                'piece_id' => $piece->id,
                'uuid' => $user->uuid,
                'url' => $path,
            ]);
        }
    }
}
