<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateOnboardingTables extends Migration
{
    public function up(): void
    {
        // the game table

        Schema::create('inside_onboarding_games', function (Blueprint $table) {
            $table->increments('id');
            foreach (config('game') as $name => $field) {
                if (array_key_exists('index', $field)) {
                    $table->index($field['index']);
                } else {
                    if (!array_key_exists('type', $field) || !$name) {
                        throw new Exception("error : you must enter a valid type and name");
                    }
                    $type = $table->{$field['type']}($name, array_key_exists('length', $field) ? $field['length'] : null);
                    if (array_key_exists('nullable', $field)) {
                        $type->nullable();
                    }
                    if (array_key_exists('default', $field)) {
                        $type->default($field['default']);
                    }
                }
            }
            $table->timestamps();
        });

        // the pieces table
        Schema::create('inside_onboarding_pieces', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('game_id');
            $table->unsignedInteger('position');
            $table->string('title');
            $table->longText('urls');
            $table->text('hover');
            $table->longText('image');
            $table->timestamps();

            $table->foreign('game_id')
                ->references('id')->on('inside_onboarding_games')
                ->onDelete('cascade');
            $table->index('game_id');
            $table->index('position');
            $table->index('title');
        });

        Schema::create('inside_onboarding_turns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('game_id');
            $table->unsignedInteger('piece_position');
            $table->unsignedBigInteger('piece_id');
            $table->uuid('uuid');
            $table->text('url');
            $table->timestamps();

            $table->foreign('game_id')
                ->references('id')->on('inside_onboarding_games')
                ->onDelete('cascade');
            $table->foreign('piece_position')
                ->references('position')->on('inside_onboarding_pieces')
                ->onDelete('cascade');
            $table->foreign('piece_id')
                ->references('id')->on('inside_onboarding_pieces')
                ->onDelete('cascade');
            $table->foreign('uuid')
                ->references('uuid')->on('inside_content_users')
                ->onDelete('cascade');

            $table->index(['game_id','piece_position', 'piece_id']);
            $table->index('uuid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_onboarding_turns');
        Schema::dropIfExists('inside_onboarding_pieces');
        Schema::dropIfExists('inside_onboarding_games');
    }
}
