<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace' => 'Inside\Onboardings\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => ['auth.api'],
    ],
    function ($router) {
        $router->get('games', ['uses' => 'GameController@getAllGames']);
        $router->get('game/user/pieces', ['uses' => 'GameController@piecesFound']);
        $router->get('game/user/progression', ['uses' => 'GameController@getProgression']);
    }
);

//administrate game
Route::group(
    [
        'namespace' => 'Inside\Onboardings\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => ['auth.backoffice.access:game'],
    ],
    function ($router) {
        $router->get('game/{id}', ['uses' => 'GameController@getGame']);
        $router->post('game', ['uses' => 'GameController@create']);
        $router->put('game/{id}', ['uses' => 'GameController@edit']);
        $router->patch('game/{id}/status', ['uses' => 'GameController@toggleStatus']);
        $router->delete('game/{id}', ['uses' => 'GameController@delete']);
        $router->get('game/{id}/participants', ['uses' => 'GameController@getParticipants']);
        $router->get('game/{id}/statistics', ['uses' => 'GameController@getStatistics']);
    }
);
