<?php

namespace Inside\Onboardings\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;
use Inside\Database\Eloquent\WithEnhancedBuilder;

class OnboardingTurns extends Model
{
    use WithEnhancedBuilder;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_onboarding_turns';

    /**
     * Casts the following attributes
     *
     * @var array
     */
    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
    ];


    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'game_id',
        'piece_position',
        'piece_id',
        'uuid',
        'url'
    ];

    // todo: need to see later if we can just switch piece_position with piece_id
    public function piece(): BelongsTo
    {
        return $this->belongsTo('Inside\Onboardings\Models\OnboardingPieces', 'piece_position', 'position');
    }

    public function game(): BelongsTo
    {
        return $this->belongsTo('Inside\Onboardings\Models\OnboardingGames', 'game_id', 'id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo('Inside\Authentication\Models\User', 'uuid', 'uuid');
    }

    public function information(): HasManyThrough
    {
        return $this->hasManyThrough('Inside\Content\Models\Contents\Users', 'Inside\Authentication\Models\User', 'uuid', 'uuid', 'uuid');
    }
}
