<?php

namespace Inside\Onboardings\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OnboardingPieces extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_onboarding_pieces';

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
       'game_id',
        'position',
        'title',
        'urls',
        'hover',
        'image'
    ];

    /*
    **
    * The game that is linked to the piece
    */
    public function game(): BelongsTo
    {
        return $this->belongsTo('Inside\Onboardings\Models\OnboardingGames', 'game_id', 'id');
    }
}
