<?php

namespace Inside\Newsletters\Services;

use Inside\Settings\Models\Setting;
use Illuminate\Support\Collection;

class NewsletterConfigService
{
    public static function loadFromSettings(string $type, string $langcode): Collection
    {
        $numberNewletters = collect(data_get(config('newsletters'), 'types'))->keys()->count();

        $commonSettings = [
            'introduction.showGreetings' => 'newsletters_display_hello',
            'logo.logoUrl' => 'newsletters_logo',
            'banner.backgroundImageUrl' => 'newsletters_banner',
        ];
        $customSettings = [
            'banner.title' => '%s_name_%s',
            'banner.subTitle' => '%s_description_%s',
            'banner.bannerImageTextColor' => '%s_text_color_%s',
        ];

        $isGlobalConfigDisabled = data_get(config('newsletters'), 'types.newsletters.global_config_disabled');
        if ($numberNewletters > 1 || $isGlobalConfigDisabled) {
            $customSettings = [];
            $commonSettings = [
                'introduction.showGreetings' => 'newsletters_display_hello',
            ];
        }

        $settings = collect($commonSettings)->merge(
            collect($customSettings)->mapWithKeys(
                fn ($setting, $key) => [$key => sprintf($setting, $type, $langcode)]
            )
        )->toArray();

        $settingsKeys = array_flip($settings);

        return Setting::where([
            'group' => 'newsletter'
        ])->whereIn('key', $settings)
            ->get()
            ->pluck('value', 'key')
            ->mapWithKeys(fn ($v, $k) => [$settingsKeys[$k] => $v]);
    }
}
