<?php

namespace Inside\Newsletters\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Content\Models\Content;

/**
 * @method static insert($query, array $bindings = [])
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder selectRaw(string $expression, array $bindings = [])
 * @method static Builder join(string $table, string $first, string $operator = null, string $second = null, string $type = 'inner', bool $where = false)
 * @method static Builder rightJoin(string $table, string $first, string $operator = null, string $second = null, string $type = 'right', bool $where = false)
 */
class NewslettersStatisticsGeneric extends Content
{
    public const TYPE_SENT = 'sent';
    public const TYPE_CLICKED = 'clicked';
    public const TYPE_VIEWED = 'viewed';

    public const TYPES = [
        self::TYPE_SENT,
        self::TYPE_CLICKED,
        self::TYPE_VIEWED,
    ];

    protected $table = null;

    protected string $type = '';

    protected $fillable = [
        'user_uuid',
        'content_uuid',
        'statistic_type',
        'created_at',
    ];

    protected function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    public static function bind(string $type): self
    {
        $statistic = new self();
        $statistic->setType($type);
        $type = type_to_stats_table($type);
        if ($type === null) {
            throw new \Exception('Provided type not valid: ' . $type);
        }
        $statistic->setTable($type);

        return $statistic;
    }

    public function newInstance($attributes = [], $exists = false)
    {
        $model = parent::newInstance($attributes, $exists);
        $model->setType($this->type);
        $model->setTable($this->table);

        return $model;
    }

    public function setType(string $type): void
    {
        $this->type = $type;
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(type_to_class('users'));
    }

    public function content(): BelongsTo
    {
        return $this->belongsTo(type_to_class($this->type));
    }

    protected static function boot()
    {
        parent::boot();
    }
}
