<?php

namespace Inside\Newsletters\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Newsletters\Events\NewsletterTestTriggeredEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;
use Inside\User\Models\User;

/**
 * Newsletter test triggered listener
 *
 * @category Class
 * @package  Inside\Newsletters\Listeners\NewsletterTestTriggeredListener
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class NewsletterTestTriggeredListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(NewsletterTestTriggeredEvent $event): void
    {
        $model = $event->model;
        $emails = $event->emails;

        /** @var NotificationType|null $type */
        $type = NotificationType::where('event', NewsletterTestTriggeredEvent::class)->first();

        if (is_null($type)) {
            return;
        }

        $config = config('newsletters');

        $data = $config['types'][class_to_type($model)] ?? [];

        $subscribers = User::query()->where('status', 1)->whereIn('email', $emails)->get();

        $subscribers->each(function ($subscriber) use ($type, $model, $data) {
            $this->route = $subscriber;
            $this->notify($type, $subscriber, $model, ['extra' => $data['notification']], [], 'newsletter');
        });
    }
}
