<?php

namespace Inside\Newsletters\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;
use Inside\Content\Models\Content;
use Inside\Host\Bridge\BridgeContent;
use Inside\Jobs\Job;
use Inside\Newsletters\Events\NewsletterTriggeredEvent;

class SendNewsletterJob extends Job implements ShouldQueue
{
    use InteractsWithQueue;
    use Queueable;

    /**
     * @param Content $model
     */
    public function __construct(private Content $model)
    {
    }

    public function handle(): void
    {
        $this->model->refresh();

        if (blank($this->model->scheduled_at) || get_date($this->model->scheduled_at)?->isFuture()) {
            Log::info('[Inside newsletter] Scheduled newsletter is not ready to be sent yet: '.$this->model->uuid);

            return;
        }

        Log::info('[Inside newsletter] Scheduled newsletter is ready to be sent: '.$this->model->uuid);

        NewsletterTriggeredEvent::dispatch($this->model);

        (new BridgeContent())->contentUpdate(class_to_type($this->model::class), [
            'uuid' => $this->model->uuid,
            'scheduled_at' => null,
        ]);
    }
}
