<?php

namespace Inside\Newsletters\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Inside\Permission\Facades\Permission;
use Inside\Permission\Facades\Role as RoleService;
use Inside\Permission\Models\Role;

/**
 * Newsletter middleware
 *
 * @category Class
 * @package  Inside\Newsletters\Http\Middleware\NewslettersMiddleware
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class NewslettersFormMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        $path = $request->path();

        if (str_starts_with($path, 'api/v1/content/')
            && in_array($request->getMethod(), ['POST', 'PUT'])
            && $request->has('newsletter_roles')) {
            $input = $request->all();
            $input['newsletter_roles'] = json_encode($input['newsletter_roles']);

            $request->replace($input);

            return $next($request);
        }

        $response = $next($request);

        if (!str_contains($path, 'api/v1/form/')) {
            return $response;
        }

        $config = config('newsletters');
        $types = array_keys($config['types']);

        $segments = explode('/', $path);
        $type = $segments[3];

        if (!in_array($type, $types)) {
            return $response;
        }

        $data = json_decode_response($response);

        $newsletterRolesFieldsetLabel = [];
        foreach (list_languages() as $locale) {
            $newsletterRolesFieldsetLabel[$locale] = trans('newsletter.fieldsets.newsletter_roles', [], $locale);
        }
        $result = [
            'id' => 'group_newsletter_roles',
            'weight' => 50,
            'type' => 'fieldset',
            'classes' => '',
            'label' => $newsletterRolesFieldsetLabel,
            'fields' => [],
        ];

        $defaultRoles = $config['types'][$type]['default_roles'] ?? [];
        $defaultRoleIDs = Role::query()->whereIn('name', $defaultRoles)->pluck('id')->toArray();

        $route = $request->route();
        $content = null;
        if (isset($route[2]['id'])) {
            $content = call_user_func(type_to_class($type).'::findOrFail', $route[2]['id']);
        }

        $result['fields'][] = Permission::getRolePickerFieldForFrontForm(
            'newsletter_roles',
            'newsletter.fields.roles',
            $content,
            [],
            51
        );

        $data['data'][] = $result;
        set_response($response, $data);

        return $response;
    }
}
