<?php

namespace Inside\Newsletters\Http\Controllers;

use Inside\Newsletters\Models\TestEmail;
use Laravel\Lumen\Routing\Controller;
use Illuminate\Http\Response;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class TestEmailsController extends Controller
{
    public function list(): JsonResponse
    {
        $emails = TestEmail::pluck('email')->toArray();

        $userEmail = auth()->user()->email ?? null;

        $uniqueEmails = collect($emails)
            ->merge([$userEmail])
            ->filter()
            ->unique()
            ->values();

        return response()->json($uniqueEmails);
    }

    public function store(Request $request): JsonResponse
    {
        $this->validate($request, [
            'email' => 'required|email|unique:test_emails,email',
        ]);

        $email = TestEmail::create([
            'email' => $request->input('email')
        ]);

        return response()->json($email, 201);
    }

    public function delete(string $email): JsonResponse
    {
        $decodedEmail = urldecode($email);

        $testEmail = TestEmail::where('email', $decodedEmail)->first();

        if (!$testEmail) {
            return response()->json(['message' => 'Email not found.'], 404);
        }

        $testEmail->delete();

        return response()->json(['message' => 'Email deleted successfully.']);
    }
}
