<?php

namespace Inside\Newsletters\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Inside\Content\Models\Content;
use Inside\Events\Dispatchable;

/**
 * Content created event.
 *
 * @category Class
 * @package  Inside\Content\Events\ContentCreatedEvent
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class NewsletterTriggeredEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    public function __construct(
        public Content $model
    ) {
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside_newsletter_triggered');
    }
}
