<?php

namespace Inside\Newsletters\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Inside\Content\Models\Content;
use Inside\Events\Dispatchable;

/**
 * Newsletter test triggered event.
 *
 * @category Class
 * @package  Inside\Newsletters\Events\NewsletterTestTriggeredEvent
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class NewsletterTestTriggeredEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    /**
     * The emails to send the newsletter to
     */
    public array $emails;

    public function __construct(
        public Content $model,
        string $emails
    ) {
        $this->emails = explode(',', $emails);
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside_newsletter_test_triggered');
    }
}
