<?php

namespace Inside\Newsletters\Console\Commands;

use Illuminate\Console\Command;
use Inside\Newsletters\Services\NewsletterSettingService;

class SetupNewsletterSettings extends Command
{
    protected $signature = 'inside:newsletter:setup:settings';
    protected $description = 'Update settings for newsletters based on configuration files';

    public function __construct(private NewsletterSettingService $newsletterSettingService)
    {
        parent::__construct();
    }

    public function handle(): void
    {
        $this->info('[Newsletter settings] : Start create newsletter settings');
        $this->line('');
        $this->newsletterSettingService
            ->attachCmdOutput($this->getOutput())
            ->execute();
        $this->info('[Newsletter settings] : Newsletter settings created with success');
    }
}
