<?php

namespace Inside\Newsletters\Console\Commands;

use Illuminate\Console\Command;
use Inside\Newsletters\Jobs\CreateScheduledNewsletter;

class CreateScheduledNewsletterCommand extends Command
{
    private const FAILURE = 1;
    private const SUCCESS = 0;

    protected $signature = 'inside:newsletter:scheduled:create {type}';

    protected $description = 'Create a scheduled newsletter of type {type}';

    public function handle(): int
    {
        $type = $this->argument('type');

        try {
            CreateScheduledNewsletter::dispatchNow($type, $this->getOutput());
        } catch (\Exception $exception) {
            $this->error($exception->getMessage());
            return self::FAILURE;
        }

        return self::SUCCESS;
    }
}
