<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Inside - Newsletter</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <style type="text/css" style="display: none !important;">
        img {
            height: auto;
        }

        .inside-image {
            max-width: 100% !important;
            height: auto !important;
            display: block !important;
        }

        @media screen and (min-width: 700px) {
            .mobile {
                display: none !important;
            }
        }

        @media screen and (max-width: 700px) {
            .outer {
                width: 350px !important;
            }

            .inner {
                max-width: 280px !important;
                width: 280px !important;
            }

            .mobile-show {
                display: table-row !important;
            }

            .no-mobile {
                display: none !important;
            }

            .sub-background {
                background: #fff !important;
            }

            .flex-mobile > td {
                display: block !important;
                width: 100% !important;
                direction: ltr !important;
            }


            .social-container {
                display: flex;
                justify-content: center;
            }
        }

        ul.triangular-bullet > li {
            list-style-type: disclosure-closed !important;
            color: {{ setting('general', 'color_primary', '#2f2f2f') }} !important;
        }

        p.ds-base-text-container[style*="text-align: center"] > img.inside-image {
            margin: 0 auto;
        }
    </style>
    @if (!isset($options['preview']))
        <img src="{{ $trackingPixelUrl }}">
    @endif
</head>
<body style="background: #ffffff;">
@spaceless
<x-iln::logo :options="$options['logo'] ?? []" />
<x-iln::banner :options="$options['banner'] ?? []" />
<x-iln::container :options="$options" />
<x-iln::cta :options="$options['cta'] ?? []" />
<x-iln::socials :options="$options['socials'] ?? []" />
<x-iln::footer :options="$options['footer'] ?? []" />
@endspaceless
</body>
</html>
