@props(['options' => []])
@php
    use Inside\Settings\Models\Setting;
    $backgroundColor = $options['backgroundColor'] ?? '#EA9675';
    $defaultTextColor = $options['defaultTextColor'] ?? '#FFFFFF';
    $socialLinks = $options['links'] ?? [];
    $secondLineLinks = $options['secondLineLinks'] ?? [];
    $width = 130 * count($socialLinks);
    $secondLineWidth = 130 * count($secondLineLinks);
    $showNewsletterFooter =  Setting::where('key', 'show_newsletter_footer')->value('value')
@endphp

@if(!empty($socialLinks) && $showNewsletterFooter)
    <table cellpadding="0" cellspacing="0" border="0" style="width: 100%; background: {{$backgroundColor}};">
        <tr>
            <td align="center">
                <table cellpadding="0" cellspacing="0" border="0">
                    <tr>
                        <td style="height: 24px;">
                            <span></span>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: {{ $width }}px;" class="outer" align="center">
                            <table cellpadding="0" cellspacing="0" border="0">
                                <tr>
                                    <td style="width: {{ $width }}px;" class="inner">
                                        <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                                            <tbody>
                                            <tr class="flex-mobile">
                                                @foreach($socialLinks as $name => $socialLinkOptions)
                                                    <x-iln::partials.social
                                                        :options="array_merge(['defaultTextColor' => $defaultTextColor, ], $socialLinkOptions)"
                                                        :name="$name" />
                                                @endforeach
                                            </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    @if (!empty($secondLineLinks))
                        <tr>
                            <td style="height: 16px;">
                                <span></span>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: {{ $secondLineWidth }}px;" class="outer" align="center">
                                <table cellpadding="0" cellspacing="0" border="0">
                                    <tr>
                                        <td style="width: {{ $secondLineWidth }}px;" class="inner">
                                            <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                                                <tbody>
                                                <tr class="flex-mobile">
                                                    @foreach($secondLineLinks as $name => $socialLinkOptions)
                                                        <x-iln::partials.social
                                                            :options="array_merge(['defaultTextColor' => $defaultTextColor, ], $socialLinkOptions)"
                                                            :name="$name" />
                                                    @endforeach
                                                </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    @endif
                    <tr>
                        <td style="height: 24px;">
                            <span></span>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
@endif
