@props(['itemOptions' => [], 'item' =>null, 'last' => false])
@php
    use Illuminate\Support\Carbon;
    use Inside\Support\Str;
    use Illuminate\Support\Arr;
    use Inside\Content\Facades\Schema as InsideSchema;
    use Inside\Newsletters\Facades\UrlSigner;


    // Prepare options
    $imageStyle = $itemOptions['imageStyle'] ?? 'thumbnail';
    $showDate = $itemOptions['showDate'] ?? true;
    $dateFormat = $itemOptions['dateFormat'] ??'%d/%m/%Y';
    $dateColor = $itemOptions['dateColor'] ?? '#A7A7A7';
    $dateFieldName = $itemOptions['dateFieldName'] ?? 'published_at';
    $defaultImageUrl = $itemOptions['defaultImageUrl'] ?? (config('app.url') . '/vendor/maecia/inside-newsletters/resources/images/iln/default_thumbnail.png');
    $showCategoryTitle = $itemOptions['showCategoryTitle'] ?? false;
    $defaultCategoryColor = $itemOptions['defaultCategoryColor'] ?? '#EA9675';
    $categoryFieldName = $itemOptions['categoryFieldName'] ?? '';
    $titleColor = $itemOptions['titleColor'] ??'#2C3E50';
    $showIntroduction = $itemOptions['showIntroduction'] ?? false;
    $introductionColor = $itemOptions['introductionColor'] ?? '#4D4D4D';
    $introductionLength = $itemOptions['introductionLength'] ?? 100;
    $introductionFieldName = $itemOptions['introductionFieldName'] ?? '';

    // Prepare categories if enabled
    if($showCategoryTitle && InsideSchema::hasField(class_to_type($item), $categoryFieldName) && $item->{Str::camel($categoryFieldName)} !== null) {
        $categoryFieldOptions = InsideSchema::getFieldOptions(class_to_type($item), $categoryFieldName);
        $categoryContent = Arr::first($categoryFieldOptions['target']);
        $categories = [];
        if($categoryContent) {
            $contentCategories = $item->{Str::camel($categoryFieldName)};
            if ($categoryFieldOptions['cardinality'] == 1) {
                $contentCategories = [$contentCategories];
            }
            foreach ($contentCategories->take(3) as $contentCategory) {
                 $categories[] = [
                    'title' => $contentCategory->title,
                    'color' => ((InsideSchema::hasField($categoryContent, 'color') && $contentCategory->color !== null && !empty($contentCategory->color)) ? $contentCategory->color : $defaultCategoryColor),
                ];
            }
        }
    } else {
        $showCategoryTitle = false;
    }

    $thumbnailUrl = newsletter_signed_url($user, $newsletter, $item, get_stylized_image_url($item, 'image', $imageStyle ?? 'thumbnail', true), $defaultImageUrl . '?'.time());
    $url = 'external-url/'.$item->contentType.'/'.$item->uuid;
    if (!isset($options['preview'])) {
        $url = UrlSigner::signedRoute('newsletters.clicked', ['type' => $newsletter->content_type, 'newsletterUuid' => $newsletter->uuid, 'userUuid' => $user->uuid, 'redirect' => $url]);
    } else {
        $url = url($url);
    }
@endphp
<tr>
    <td>
        <table cellpadding="0" class="news-container" cellspacing="0" border="0" style="width: 100%; margin-bottom: 15px">
            <tr>
                <td>
                    <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                        <tr>
                            <td class="no-mobile" style="width: 148px;">
                                <a href="{{ $url }}" target="_blank"
                                   style="text-decoration: none;">
                                    <img src="{{ $thumbnailUrl }}" alt="{{ $item->title }}"
                                         style="display: block;height: auto;" width="148" />
                                </a>
                            </td>
                            <td class="no-mobile" style="width: 16px;" width="16">
                                <span></span>
                            </td>
                            <td>
                                <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                                    <tr>
                                        <td>
                                            <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                                                <tr>
                                                    @if($showDate)
                                                        <td style="width: 75px;" width="75">
                                                            <p style="color: {{ $dateColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; margin: 0;">{{ ucwords(get_date_in_user_timezone($item->{$dateFieldName})->formatLocalized($dateFormat)) }}</p>
                                                        </td>
                                                        <td style="padding-left:10px; width: 150%">
                                                            <p style="color: {{ $dateColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; margin: 0;">{{ $item->folders->implode('title', ' / ') }}</p>
                                                        </td>
                                                        <td style="width: 8px;" width="8">
                                                            <span></span>
                                                        </td>
                                                    @endif
                                                    @if($showCategoryTitle)
                                                        <td>
                                                            @foreach($categories as $category)
                                                                <p style="color: {{ $category['color'] }}; font-family: Arial; font-size: 14px; letter-spacing: 0; line-height: 16px; margin: 0;">{{ $category['title'] }}</p>
                                                            @endforeach
                                                        </td>
                                                    @endif
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="height: 10px;">
                                            <span></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <a href="{{ $url }}"
                                               target="_blank" style="text-decoration: none;">
                                                <h2 style="color: {{ $titleColor }}; font-family: Arial; font-size: 17px; font-weight: bold; letter-spacing: 0; line-height: 21px; margin: 0;">
                                                    {{ $item->title }}</h2></a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="height: 10px;">
                                            <span></span>
                                        </td>
                                    </tr>
                                    @if($showIntroduction && !empty($item->{$introductionFieldName}))
                                        <tr>
                                            <td>
                                                <p style="color: {{ $introductionColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; line-height: 20px; margin: 0;">
                                                    {{ htmlTruncate(strip_tags(html_entity_decode($item->{$introductionFieldName})), $introductionLength) }}</p>
                                            </td>
                                        </tr>
                                    @endif
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            @if(!$last)
                <tr>
                    <td style="height: 32px;">
                        <span></span>
                    </td>
                </tr>
            @endif
        </table>
    </td>
</tr>
