@props(['itemOptions' => [], 'item' => null, 'last' => false])
@php
    $imageStyle = $itemOptions['imageStyle'] ?? 'thumbnail';
    $defaultImageUrl = $itemOptions['defaultImageUrl'] ?? (config('app.url') . '/vendor/maecia/inside-newsletters/resources/images/iln/default_thumbnail.png');

$body = preg_replace("/<img[^>]+\>/i", "(image) ", $item->body);
@endphp
@if($item->display == 'center')
    <tr>
        <td>
            <img
                src="{{ newsletter_signed_url($user, $newsletter, $item, get_stylized_image_url($item, 'image', $imageStyle ?? 'thumbnail', true),  $defaultImageUrl . '?'.time()) }}"
                width="100%"/>
        </td>
    </tr>
    <tr>
        <td>
            {!! $body !!}
        </td>
    </tr>
@else
    <tr>
        <td>
            <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                @if($item->display == 'left')
                    <tr style="vertical-align: top;">
                        <td style="width: 250px;">
                            <img
                                src="{{ newsletter_signed_url($user, $newsletter, $item, get_stylized_image_url($item, 'image', $imageStyle ?? 'thumbnail', true),  $defaultImageUrl . '?'.time()) }}"
                                width="250px"/>
                        </td>
                        <td class="no-mobile" style="width: 16px;" width="16">
                            <span></span>
                        </td>
                        <td>
                            {!! $body !!}
                        </td>
                    </tr>
                @elseif($item->display == 'right')
                    <tr style="vertical-align: top;">
                        <td>
                            {!! $body !!}
                        </td>
                        <td class="no-mobile" style="width: 16px;" width="16">
                            <span></span>
                        </td>
                        <td style="width: 250px;">
                            <img
                                src="{{ newsletter_signed_url($user, $newsletter, $item, get_stylized_image_url($item, 'image', $imageStyle ?? 'thumbnail', true),  $defaultImageUrl . '?'.time()) }}"
                                width="250px"/>
                        </td>
                    </tr>
                @endif
            </table>
        </td>
    </tr>
@endif
<tr>
    <td style="height: 16px;">
        <span></span>
    </td>
</tr>
