@props(['sectionLinkOptions' => [], 'sectionName' => 'section'])
@php
    use Inside\Newsletters\Facades\UrlSigner;
    use Inside\Settings\Models\Setting;

    $sectionLinkStrKey  = $sectionLinkOptions['sectionLinkStrKey'] ?? 'newsletter.'.$sectionName.'_link';
    $sectionLinkUrl =  $sectionLinkOptions['sectionLinkUrl'] ?? '/';
    if (!isset($options['preview'])) {
        $sectionLinkUrl = UrlSigner::signedRoute('newsletters.clicked', ['type' => $newsletter->content_type, 'newsletterUuid' => $newsletter->uuid, 'userUuid' => $user->uuid, 'redirect' => $sectionLinkUrl]);
    }
    $sectionTextColor = Setting::where('key', 'color_primary')->first()?->value ?? $sectionLinkOptions['sectionTextColor'] ?? '#EB9D7E';
@endphp
<table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
    <tr>
        <td style="height: 32px">
            <span></span>
        </td>
    </tr>
    <tr>
        <td align="right">
            <table cellpadding="0" cellspacing="0" border="0"
                   style="width: auto; margin-right: 0px; margin-left: auto;">
                <tr>
                    <td>
                        <table cellpadding="0" cellspacing="0" border="0">
                            <tr>
                                <td style="width: 8px;">
                                    <span></span>
                                </td>
                                <td>
                                    <a href="{{ url($sectionLinkUrl) }}" style="text-decoration: none;" target="_blank">
                                        <span
                                                style="color: {{ $sectionTextColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; line-height: 16px;">&#8594; {{ __($sectionLinkStrKey) }}</span>
                                    </a>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td style="height: 40px">
            <span></span>
        </td>
    </tr>
</table>
