@props(['itemOptions' => [], 'item' => null, 'last' => false])
@php
    use Illuminate\Support\Carbon;
    use Inside\Settings\Models\Setting;
    use Inside\Support\Str;
    use Illuminate\Support\Arr;
    use Inside\Content\Facades\Schema as InsideSchema;
    use Inside\Newsletters\Facades\UrlSigner;

    // Prepare options
    $imageStyle = $itemOptions['imageStyle'] ?? 'thumbnail';
    $dateFormat = $itemOptions['dateFormat'] ??'%d/%m/%Y';
    $dateColor = $itemOptions['dateColor'] ?? '#A7A7A7';
    $showImage = $itemOptions['showImage'] ?? false;
    $defaultImageUrl = $itemOptions['defaultImageUrl'] ?? (config('app.url') . '/vendor/maecia/inside-newsletters/resources/images/iln/default_thumbnail.png');

    $defaultCategoryColor = Setting::where('key', 'color_primary')->first()?->value ?? $itemOptions['defaultCategoryColor'] ?? '#EA9675';
    $categoryFieldName = $itemOptions['categoryFieldName'] ?? 'events_categories';
    $titleColor = $itemOptions['titleColor'] ??'#2C3E50';

    $startDateFieldName = $itemOptions['stardDateFieldName'] ?? 'date';
    $endDateFieldName = $itemOptions['endDateFieldName'] ?? 'end_date';
    $showTime = $itemOptions['showTime'] ?? false;

    // date
    $startDate = get_date_in_user_timezone($item->{$startDateFieldName});
    $endDate   = (InsideSchema::hasField(class_to_type($item), $endDateFieldName) && $item->{$endDateFieldName} !== null && $item->{$endDateFieldName} > 0) ?
    get_date_in_user_timezone($item->{$endDateFieldName}) : null;

    $date = ucwords($startDate->formatLocalized($dateFormat));
    if ($endDate !== null) {
        if ($startDate->isSameDay($endDate) ) {
            if( $showTime) {
               $date .= __('newsletter.from_time') . $startDate->format('H:i') . __('newsletter.to_time') . $endDate->format('H:i');
            }
        } elseif($endDate !== null) {
           $date .= ' - '  . ucwords($endDate->formatLocalized($dateFormat));
        }
    } elseif($showTime) {
        $date .= __('newsletter.at_time') . $startDate->format('H:i');
    }

    $leftLineColor = $defaultCategoryColor;
    // Prepare color
    if (InsideSchema::hasField(class_to_type($item), $categoryFieldName) && $item->{Str::camel($categoryFieldName)} !== null) {
        $categoryFieldOptions = InsideSchema::getFieldOptions(class_to_type($item), $categoryFieldName);
        $categoryContent = Arr::first($categoryFieldOptions['target']);
        $categories = [];
        if ($categoryContent) {
            $contentCategories = $item->{Str::camel($categoryFieldName)};
            foreach ($contentCategories as $contentCategory) {
                 $categories[] = [
                    'title' => $contentCategory->title,
                    'color' => ((InsideSchema::hasField($categoryContent, 'color') && $contentCategory->color !== null && !empty($contentCategory->color)) ? $contentCategory->color : $defaultCategoryColor),
                ];
            }
            if (!empty($categories) && (null !== ($firstCategory = Arr::first($categories)))) {
                $leftLineColor = $firstCategory['color'];
            }
        }
    }

    if (!isset($options['preview'])) {
        $url = UrlSigner::signedRoute('newsletters.clicked', ['type' => $newsletter->content_type, 'newsletterUuid' => $newsletter->uuid, 'userUuid' => $user->uuid, 'redirect' => Arr::first($item->slug)]);
    } else {
        $url = url(Arr::first($item->slug));
    }
@endphp
<tr>
    <td>
        <table class="event-container" cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
            <tr>
                <td style="width: 6px; background: {{ $leftLineColor }}" width="6px">
                        <span
                                style="display: block; width: 6px; height: 100%; background: {{ $leftLineColor }}; height: {{ $showImage ? '100':'60' }}px;"
                                width="6px"></span>
                </td>
                @if($showImage)
                    <td class="no-mobile" style="width: 8px;" width="8px">
                        <span></span>
                    </td>
                    <td class="no-mobile" style="width: 148px;" width="140px">
                        <a href="{{ $url }}" target="_blank"
                           style="text-decoration: none;">
                            <img
                                    src="{{ newsletter_signed_url($user, $newsletter, $item, get_stylized_image_url($item, 'image', $imageStyle ?? 'thumbnail', true), $defaultImageUrl . '?'.time()) }}"
                                    alt="{{ $item->title }}" style="display: block; max-width: 100%;"/>
                        </a>
                    </td>
                    <td class="no-mobile" style="width: 16px;" width="16px">
                        <span></span>
                    </td>
                @endif
                <td style="width: 16px;" width="16px">
                    <span></span>
                </td>
                <td>
                    <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                        <tr>
                            <td style="height: 8px;" width="8px">
                                <span></span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p style="color: {{ $dateColor }}; font-family: Arial; font-size: 14px; letter-spacing: 0; margin: 0;">{{ $date }}</p>
                            </td>
                        </tr>
                        @if($showImage)
                            <td class="mobile-show" style="height: 8px; display: none;" height="8px">
                                <span></span>
                            </td>
                            <td class="mobile-show" style="width: 140px; display: none;" width="140px">
                                <a href="{{ $url }}" target="_blank"
                                style="text-decoration: none;">
                                    <img
                                        src="{{ newsletter_signed_url($user, $newsletter, $item, get_stylized_image_url($item, 'image', $imageStyle ?? 'thumbnail', true), $defaultImageUrl . '?'.time()) }}"
                                        alt="{{ $item->title }}" style="display: block; max-width: 100%;"/>
                                </a>
                            </td>
                            <td class="mobile-show" style="height: 8px; display: none;" height="8px">
                                <span></span>
                            </td>
                        @endif
                        <tr>
                            <td style="width: 8px;" width="8px">
                                <span></span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <a href="{{ $url }}" target="_blank"
                                   style="text-decoration: none;"><h2
                                            style="color: {{ $titleColor }}; font-family: Arial; font-size: 17px; font-weight: bold; letter-spacing: 0; line-height: 21px; margin: 0;">
                                        {{ $item->title }}
                                    </h2></a>
                            </td>
                        </tr>
                        <tr>
                            <td style="height: 8px;" width="8px">
                                <span></span>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </td>
</tr>
@if(!$last)
    <tr>
        <td style="height: 16px;" width="16px">
            <span></span>
        </td>
    </tr>
@endif
