@props(['options' => []])
@php
    use Inside\Support\Str;


    $logoUrl = $options['logoUrl'] ?? null;
    if ($logoUrl !== null && ! Str::startsWith($logoUrl, 'http')) {
        if (File::exists(cms_base_path($logoUrl))) {
            $logoUrl = url(path: $logoUrl, secure: true);
        } else {
            $logoUrl = url('/newsletter_assets', [$logoUrl,'nl_logo']);
        }
    }
    $showLogo = $options['showLogo'] ?? ! is_null($logoUrl);
    $logoWidth =  $options['logoWidth'] ?? 205;
    $showDate =  $options['showDate'] ?? false;
    $dateColor =  $options['dateColor'] ?? '#a7a7a7';
    $dateFormat = $options['dateFormat'] ?? '%A %d %B %Y';
@endphp
@if($showLogo || $showDate)
    <table cellpadding="0" cellspacing="0" border="0" align="center">
        <tr>
            <td style="width: 600px;">
                <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                    <tr>
                        <td style="width: 50%;">
                            <span style="width: 100%;"></span>
                        </td>
                        <td style="width: {{ $logoWidth }}px;">
                            @if($showLogo)
                                <img
                                    style="min-width: {{ $logoWidth }}px;"
                                    src="{{ $logoUrl }}" width="{{ $logoWidth }}" alt="{{ config('app.name') }}" />
                            @else
                                &nbsp;
                            @endif
                        </td>
                        <td style="width: 100%; height: 50px">
                            @if($showDate)
                                <x-iln::partials.header-date :options="$options"/>
                            @endif
                        </td>
                        <td style="width: 50%;">
                            <span style="width: 100%;"></span>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td style="height: 16px;">
                <span></span>
            </td>
        </tr>
    </table>
@endif
