<x-layouts.dashboard.newsletters>
    {{ $config}}
    <div class="min-w-full divide-y divide-gray-200 p-4 shadow-md rounded-md text-left">
        <form class="mb-4 md:flex md:flex-wrap md:justify-between p-10"
              x-data="{
                 has_logo:{{ isset($config['logo']) && is_array($config['logo']) ? 'true' : 'false' }},
                 has_banner:{{ !isset($config['banner']) || is_array($config['banner']) ? 'true' : 'false' }},
                  }"
              action="{{ route('newsletters.dashboard.update', ['name' => $name]) }}" method="POST">
            <input type="hidden" name="_method" value="PUT">
            <fieldset class="border border-solid border-gray-300 p-3 w-full md:flex md:flex-wrap md:justify-between">
                <legend class="text-sm">Données meta</legend>
                <div class="flex flex-col mb-4">
                    <label class="mb-2 uppercase tracking-wide font-bold text-lg text-grey-darkest" for="name">Nom
                        machine</label>
                    <input class="border py-2 px-3 text-grey-darkest md:mr-2" readonly type="text" name="name"
                           value="{{ $name }}" id="name">
                </div>
                <div class="flex flex-col mb-4 md:w-1/2">
                    <label class="mb-2 uppercase tracking-wide font-bold text-lg text-grey-darkest" for="config[_meta][name]">Nom
                        de la newsletter</label>
                    <input class="border py-2 px-3 text-grey-darkest md:mr-2" type="text" name="config[_meta][name]"
                           value="{{ $config['_meta']['name'] }}" id="config[_meta][name]" placeholder="{{ $name }}">
                </div>
                <div class="flex flex-col mb-4 md:w-1/2">
                    <label class="mb-2 uppercase tracking-wide font-bold text-lg text-grey-darkest" for="config[_meta][type]">Type</label>
                    <select name="config[_meta][type]" class="border py-2 px-3 text-grey-darkest md:mr-2">
                        @foreach(\Inside\Content\Facades\Schema::getContentTypes() as $type)
                            @php
                                $info = \Inside\Content\Facades\Schema::getModelInformation($type);
                            @endphp
                            <option value="{{ $type }}"
                                    @if((!isset($config['_meta']['name']) && $type == 'newsletters') || $type == $config['_meta']['name']) selected="selected" @endif>{{ $info->options['title']['fr'] ?? $type }}</option>
                        @endforeach
                    </select>
                </div>
            </fieldset>

            <fieldset class="border border-solid border-gray-300 p-3 w-full md:flex md:flex-wrap md:justify-between">
                <legend class="text-sm">Entête logo <input type="checkbox" value="1" x-model="has_logo">.</legend>
                <div x-show="has_logo">
                    <div class="flex flex-col mb-4">
                        <label class="inline-flex items-center mt-3">
                            <input type="checkbox" class="form-checkbox h-5 w-5 text-red-600" value="1"
                                   name="config[logo][showLogo]"
                                   @if(!isset($config['logo']['showLogo']) || $config['logo']['showLogo']) checked @endif><span
                                class="ml-2 text-gray-700">Afficher le logo</span>
                        </label>
                    </div>
                    <div class="flex flex-col mb-4">
                        <label class="mb-2 uppercase tracking-wide font-bold text-lg text-grey-darkest" for="config[logo][logoUrl]">Url
                            du logo ( en relatif )</label>
                        <input class="border py-2 px-3 text-grey-darkest md:mr-2" type="text"
                               name="config[logo][logoUrl]"
                               value="{{ $config['logo']['logoUrl'] }}" id="config[logo][logoUrl]"
                               placeholder="vendor/maecia/{{ env('APP_CODE') }}-back/resources/assets/img/newsletter/logo.png">
                    </div>
                    <div class="flex flex-col mb-4">
                        <label class="mb-2 uppercase tracking-wide font-bold text-lg text-grey-darkest" for="config[logo][logoWidth]">Largeur du logo</label>
                        <input class="border py-2 px-3 text-grey-darkest md:mr-2" type="number"
                               name="config[logo][logoWidth]"
                               value="{{ $config['logo']['logoWidth'] }}" id="config[logo][logoWidth]">
                    </div>
                    <div class="flex flex-col mb-4">
                        <label class="inline-flex items-center mt-3">
                            <input type="checkbox" class="form-checkbox h-5 w-5 text-red-600" value="1"
                                   name="config[logo][showDate]"
                                   @if(!isset($config['logo']['showDate']) || $config['logo']['showDate']) checked @endif><span
                                class="ml-2 text-gray-700">Afficher la date</span>
                        </label>
                    </div>
                    <div class="flex flex-col mb-4">
                        <label class="mb-2 uppercase tracking-wide font-bold text-lg text-grey-darkest" for="config[logo][dateColor]">Url
                            du logo ( en relatif )</label>
                        <input class="border py-2 px-3 text-grey-darkest md:mr-2" type="text"
                               name="config[logo][dateColor]"
                               value="{{ $config['logo']['dateColor'] }}" id="config[logo][dateColor]"
                               placeholder="#a7a7a7">
                    </div>
                </div>
            </fieldset>
            <fieldset class="border border-solid border-gray-300 p-3 w-full md:flex md:flex-wrap md:justify-between">
                <legend class="text-sm">Bannière <input type="checkbox" value="1" x-model="has_banner">.</legend>
                <div x-show="has_banner">
                    <div class="flex flex-col mb-4">
                        <label class="mb-2 uppercase tracking-wide font-bold text-lg text-grey-darkest" for="config[banner][titleStrKey]">Titre ( clé )</label>
                        <input class="border py-2 px-3 text-grey-darkest md:mr-2" type="text"
                               name="config[banner][titleStrKey]"
                               value="{{ $config['banner']['titleStrKey'] }}" id="config[banner][titleStrKey]"
                               placeholder="newsletter.title">
                    </div>

                    <div class="flex flex-col mb-4">
                        <label class="inline-flex items-center mt-3">
                            <input type="checkbox" class="form-checkbox h-5 w-5 text-red-600" value="1"
                                   name="config[banner][showLogo]"
                                   @if(!isset($config['logo']['showLogo']) || $config['logo']['showLogo']) checked @endif><span
                                class="ml-2 text-gray-700">Afficher le logo</span>
                        </label>
                    </div>

                    // 'titleStrKey' => 'newsletter.title',
                    // 'titleColor' => '#fff',
                    // 'subTitleStrKey' => 'newsletter.sub_title',
                    // 'subTitleColor' => '#fff',
                    // 'backGroundColor' => '#1F1635',
                    // 'backGroundImageUrl' => null,
                    // 'backGroundImageAsCover' => false, // If backGroundImageUrl is set && backGroundImageAsCover is false, banner is only an image and other parameter is not used
                    // 'backGroundImageUrl' => 'vendor/maecia/opti-back/resources/assets/img/newsletter/bandeau-newsletter.jpg',
                    // 'bannerImageField' => 'banner_image',

                    <div class="flex flex-col mb-4">
                        <label class="mb-2 uppercase tracking-wide font-bold text-lg text-grey-darkest" for="config[logo][logoUrl]">Url
                            du logo ( en relatif )</label>
                        <input class="border py-2 px-3 text-grey-darkest md:mr-2" type="text"
                               name="config[logo][logoUrl]"
                               value="{{ $config['logo']['logoUrl'] }}" id="config[logo][logoUrl]"
                               placeholder="vendor/maecia/{{ env('APP_CODE') }}-back/resources/assets/img/newsletter/logo.png">
                    </div>
                    <div class="flex flex-col mb-4">
                        <label class="mb-2 uppercase tracking-wide font-bold text-lg text-grey-darkest" for="config[logo][logoWidth]">Largeur du logo</label>
                        <input class="border py-2 px-3 text-grey-darkest md:mr-2" type="number"
                               name="config[logo][logoWidth]"
                               value="{{ $config['logo']['logoWidth'] }}" id="config[logo][logoWidth]">
                    </div>
                    <div class="flex flex-col mb-4">
                        <label class="inline-flex items-center mt-3">
                            <input type="checkbox" class="form-checkbox h-5 w-5 text-red-600" value="1"
                                   name="config[logo][showDate]"
                                   @if(!isset($config['logo']['showDate']) || $config['logo']['showDate']) checked @endif><span
                                class="ml-2 text-gray-700">Afficher la date</span>
                        </label>
                    </div>
                    <div class="flex flex-col mb-4">
                        <label class="mb-2 uppercase tracking-wide font-bold text-lg text-grey-darkest" for="config[logo][dateColor]">Url
                            du logo ( en relatif )</label>
                        <input class="border py-2 px-3 text-grey-darkest md:mr-2" type="text"
                               name="config[logo][dateColor]"
                               value="{{ $config['logo']['dateColor'] }}" id="config[logo][dateColor]"
                               placeholder="#a7a7a7">
                    </div>
                </div>
            </fieldset>
            <div class="flex flex-col mb-4 mt-4">
                <button class="block bg-blue-700 hover:bg-teal-dark text-white uppercase text-lg mx-auto p-4 rounded"
                        type="submit">Enregistrer
                </button>
            </div>
        </form>
    </div>
</x-layouts.dashboard.newsletters>
